% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R
\name{distinct.ir}
\alias{distinct.ir}
\title{Subset distinct/unique rows in \code{ir} objects}
\source{
\code{\link[dplyr:distinct]{dplyr::distinct()}}
}
\usage{
distinct.ir(.data, ..., .keep_all = FALSE)
}
\arguments{
\item{.data}{An object of class \code{ir}.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Optional variables to use
when determining uniqueness. If there are multiple rows for a given
combination of inputs, only the first row will be preserved. If omitted,
will use all variables.}

\item{.keep_all}{If \code{TRUE}, keep all variables in \code{.data}.
If a combination of \code{...} is not distinct, this keeps the
first row of values.}
}
\value{
\code{.data} with distinct rows.
}
\description{
Subset distinct/unique rows in \code{ir} objects
}
\examples{
## distinct
dplyr::distinct(rep(ir_sample_data, 2))


}
\seealso{
Other tidyverse: 
\code{\link{arrange.ir}()},
\code{\link{extract.ir}()},
\code{\link{filter-joins}},
\code{\link{filter.ir}()},
\code{\link{group_by}},
\code{\link{mutate-joins}},
\code{\link{mutate}},
\code{\link{nest}},
\code{\link{pivot_longer.ir}()},
\code{\link{pivot_wider.ir}()},
\code{\link{rename}},
\code{\link{rowwise.ir}()},
\code{\link{select.ir}()},
\code{\link{separate.ir}()},
\code{\link{separate_rows.ir}()},
\code{\link{slice}},
\code{\link{summarize}},
\code{\link{unite.ir}()}
}
\concept{tidyverse}
