% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir.R
\name{ir_new_ir}
\alias{ir_new_ir}
\title{Creates an object of class \code{ir}}
\usage{
ir_new_ir(spectra, metadata = tibble::tibble())
}
\arguments{
\item{spectra}{A named list in which each element contains spectral data
for one measurement. Each list element must be a \code{data.frame} with two
columns and a row for each wavenumber value in the spectra data. The first
column must contain unique wavenumber values and the second column intensity
values of the measured spectrum of the sample.}

\item{metadata}{An optional \code{data.frame} with additional
columns containing metadata for the spectra in \code{spectra}. Optionally, an
empty \code{data.frame} can be defined if no metadata are available.}
}
\value{
An object of class \code{ir} with the following columns:
\describe{
\item{spectra}{A list column identical to \code{spectra}.}
\item{...}{Additional columns contained in \code{metadata}.}
}
}
\description{
\code{ir_new_ir} is the constructor function for objects of class
\code{ir}.
An object of class \code{ir} is a \code{\link[tibble:tbl_df-class]{tibble::tbl_df()}} with a
sample in each row and a list column containing spectra for each sample.
}
\examples{
ir_new_ir(
  spectra = ir_sample_data$spectra,
  metadata = ir_sample_data \%>\% dplyr::select(-spectra)
)

}
