% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.r
\name{ipums_callback}
\alias{ipums_callback}
\alias{IpumsChunkCallback}
\alias{IpumsSideEffectCallback}
\alias{IpumsDataFrameCallback}
\alias{IpumsListCallback}
\alias{IpumsBiglmCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors that have been adapted
for use on IPUMS microdata extracts. Though the callbacks from the
readr package will work, they will not handle implicit decimals
or add value/variable labels to the data.
}
\details{
\describe{
 \item{IpumsSideEffectCallback}{
   Callback function that is used only for side effects, no results are returned.
   Initialize with a function that takes 2 arguments x (which will be the data chunk)
   and an integer that indicates the position of the first observation in the chunk.
   If the function returns \code{FALSE}, no more chunks will be read.
 }
 \item{IpumsDataFrameCallback}{
 Callback function that combines each result together into a data.frame at the end.
   Initialize the same was as IpumsSideEffectCallback, and the results from the
   function will be fed into a data.frame.
 }
 \item{IpumsListCallback}{
   Callback function that returns a list, where each item is the result from a chunk.
   Initalize the same was as IpumsSideEffectCallback.
 }
 \item{IpumsBiglmCallback}{
   Callback function that performs a regression on the full dataset, one chunk
   at a time using the biglm package. Initialize with arguments \code{model} (A
   formula of your model and \code{prep} a function like the other callback arguments
   that prepares the data before running the regression. Other arguments are
   passed to biglm.
 }
 \item{IpumsChunkCallback}{
   (Only needed for advanced usage) Callback interface definition, all
    callback functions for IPUMS data should inherit from this class, and should
    use private method \code{ipumsify} on the data to handle implicit decimals
    and value labels.
  }
}
}
\keyword{internal}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{IpumsChunkCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IpumsChunkCallback-set_ipums_fields}{\code{IpumsChunkCallback$set_ipums_fields()}}
\item \href{#method-IpumsChunkCallback-clone}{\code{IpumsChunkCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-continue'><code>hipread::ChunkCallback$continue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-finally'><code>hipread::ChunkCallback$finally()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="initialize"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-initialize'><code>hipread::ChunkCallback$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="receive"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-receive'><code>hipread::ChunkCallback$receive()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-result'><code>hipread::ChunkCallback$result()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsChunkCallback-set_ipums_fields"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsChunkCallback-set_ipums_fields}{}}}
\subsection{Method \code{set_ipums_fields()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsChunkCallback$set_ipums_fields(
  data_structure,
  ddi,
  var_attrs,
  rt_ddi = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsChunkCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsChunkCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsChunkCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsSideEffectCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IpumsSideEffectCallback-new}{\code{IpumsSideEffectCallback$new()}}
\item \href{#method-IpumsSideEffectCallback-receive}{\code{IpumsSideEffectCallback$receive()}}
\item \href{#method-IpumsSideEffectCallback-continue}{\code{IpumsSideEffectCallback$continue()}}
\item \href{#method-IpumsSideEffectCallback-clone}{\code{IpumsSideEffectCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-finally'><code>hipread::ChunkCallback$finally()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="result"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-result'><code>hipread::ChunkCallback$result()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields"><a href='../../ipumsr/html/IpumsChunkCallback.html#method-IpumsChunkCallback-set_ipums_fields'><code>ipumsr::IpumsChunkCallback$set_ipums_fields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsSideEffectCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsSideEffectCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsSideEffectCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsSideEffectCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsSideEffectCallback-continue"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsSideEffectCallback-continue}{}}}
\subsection{Method \code{continue()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$continue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsSideEffectCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsSideEffectCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsSideEffectCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsDataFrameCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IpumsDataFrameCallback-new}{\code{IpumsDataFrameCallback$new()}}
\item \href{#method-IpumsDataFrameCallback-receive}{\code{IpumsDataFrameCallback$receive()}}
\item \href{#method-IpumsDataFrameCallback-result}{\code{IpumsDataFrameCallback$result()}}
\item \href{#method-IpumsDataFrameCallback-finally}{\code{IpumsDataFrameCallback$finally()}}
\item \href{#method-IpumsDataFrameCallback-clone}{\code{IpumsDataFrameCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-continue'><code>hipread::ChunkCallback$continue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields"><a href='../../ipumsr/html/IpumsChunkCallback.html#method-IpumsChunkCallback-set_ipums_fields'><code>ipumsr::IpumsChunkCallback$set_ipums_fields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsDataFrameCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsDataFrameCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsDataFrameCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsDataFrameCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsDataFrameCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsDataFrameCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsDataFrameCallback-finally"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsDataFrameCallback-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsDataFrameCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsDataFrameCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsDataFrameCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsListCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IpumsListCallback-new}{\code{IpumsListCallback$new()}}
\item \href{#method-IpumsListCallback-receive}{\code{IpumsListCallback$receive()}}
\item \href{#method-IpumsListCallback-result}{\code{IpumsListCallback$result()}}
\item \href{#method-IpumsListCallback-finally}{\code{IpumsListCallback$finally()}}
\item \href{#method-IpumsListCallback-clone}{\code{IpumsListCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-continue'><code>hipread::ChunkCallback$continue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields"><a href='../../ipumsr/html/IpumsChunkCallback.html#method-IpumsChunkCallback-set_ipums_fields'><code>ipumsr::IpumsChunkCallback$set_ipums_fields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsListCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsListCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$new(callback)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsListCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsListCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsListCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsListCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsListCallback-finally"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsListCallback-finally}{}}}
\subsection{Method \code{finally()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$finally()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsListCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsListCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsListCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
\section{Super classes}{
\code{\link[hipread:ChunkCallback]{hipread::ChunkCallback}} -> \code{\link[hipread:HipChunkCallback]{hipread::HipChunkCallback}} -> \code{\link[ipumsr:IpumsChunkCallback]{ipumsr::IpumsChunkCallback}} -> \code{IpumsBiglmCallback}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IpumsBiglmCallback-new}{\code{IpumsBiglmCallback$new()}}
\item \href{#method-IpumsBiglmCallback-receive}{\code{IpumsBiglmCallback$receive()}}
\item \href{#method-IpumsBiglmCallback-result}{\code{IpumsBiglmCallback$result()}}
\item \href{#method-IpumsBiglmCallback-clone}{\code{IpumsBiglmCallback$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="continue"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-continue'><code>hipread::ChunkCallback$continue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="hipread" data-topic="ChunkCallback" data-id="finally"><a href='../../hipread/html/ChunkCallback.html#method-ChunkCallback-finally'><code>hipread::ChunkCallback$finally()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ipumsr" data-topic="IpumsChunkCallback" data-id="set_ipums_fields"><a href='../../ipumsr/html/IpumsChunkCallback.html#method-IpumsChunkCallback-set_ipums_fields'><code>ipumsr::IpumsChunkCallback$set_ipums_fields()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsBiglmCallback-new"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsBiglmCallback-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$new(model, prep = function(x, pos) x, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsBiglmCallback-receive"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsBiglmCallback-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$receive(data, index)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsBiglmCallback-result"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsBiglmCallback-result}{}}}
\subsection{Method \code{result()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$result()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IpumsBiglmCallback-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IpumsBiglmCallback-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IpumsBiglmCallback$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
