% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_extract_info}
\alias{get_extract_info}
\title{Get information about a submitted extract}
\usage{
get_extract_info(extract, api_key = Sys.getenv("IPUMS_API_KEY"))
}
\arguments{
\item{extract}{One of:
\itemize{
\item An \code{\link[=ipums_extract-class]{ipums_extract}} object
\item The data collection and extract number formatted as a single string of the
form \code{"collection:number"}
\item The data collection and extract number formatted as a vector of the form
\code{c("collection", "number")}
}

The extract number does not need to be zero-padded (e.g., use \code{"usa:1"}
or \code{c("usa", "1")}, not \code{"usa:00001"} or \code{c("usa", "00001")}).
See Examples section below for examples of each form.

For a list of codes used to refer to each collection, see
\code{\link[=ipums_data_collections]{ipums_data_collections()}}.}

\item{api_key}{API key associated with your user account. Defaults to the
value of environment variable "IPUMS_API_KEY".}
}
\value{
An \code{\link[=ipums_extract-class]{ipums_extract}} object.
}
\description{
Get information about a submitted extract via the IPUMS API. For an overview
of ipumsr microdata API functionality, see
\code{vignette("ipums-api", package = "ipumsr")}.
}
\examples{
my_extract <- define_extract_usa("Example", "us2013a", "YEAR")

\dontrun{
submitted_extract <- submit_extract(my_extract)

# Get info by supplying an ipums_extract object:
get_extract_info(submitted_extract)

# Get info by supplying the data collection and extract number, as a string:
get_extract_info("usa:1")
# Note that there is no space before or after the colon, and no zero-padding
# of the extract number.

# Get info by supplying the data collection and extract number, as a vector:
get_extract_info(c("usa", "1"))
}

}
\seealso{
Other ipums_api: 
\code{\link{add_to_extract}()},
\code{\link{define_extract_cps}()},
\code{\link{define_extract_from_json}()},
\code{\link{define_extract_usa}()},
\code{\link{download_extract}()},
\code{\link{extract_list_to_tbl}()},
\code{\link{extract_tbl_to_list}()},
\code{\link{get_last_extract_info}()},
\code{\link{get_recent_extracts_info}},
\code{\link{ipums_data_collections}()},
\code{\link{is_extract_ready}()},
\code{\link{remove_from_extract}()},
\code{\link{save_extract_as_json}()},
\code{\link{set_ipums_api_key}()},
\code{\link{submit_extract}()},
\code{\link{wait_for_extract}()}
}
\concept{ipums_api}
