% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{validate_range}
\alias{validate_range}
\title{check whether IPv4 ranges are valid}
\usage{
validate_range(ranges)
}
\arguments{
\item{ranges}{a vector of IPv4 ranges}
}
\value{
a logical vector, where TRUE indicates that the
provided entry is valid, and FALSE that it is not (or
isn't an IP range at all)
}
\description{
\code{validate_range} checks whether
a vector of IPv4 CIDR ranges ("127.0.0.1/32") are valid or not.
}
\examples{
validate_range("127.0.0.1/32")
#[1] TRUE
validate_range("127.0.0.1/33")
#[1] FALSE

}
\seealso{
\code{\link{ip_classify}} for classifying
(and, incidentally, validating) IPv4 and IPv6 addresses, or
\code{\link{range_boundaries}} for identifying the minimum
and maximum IPs within a range.
}

