% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datafiles.R
\docType{data}
\name{bill}
\alias{bill}
\title{Wealth, age and region of 225 billionaires in 1992 as reported in the 
Fortune magazine}
\format{
A data frame with 225 rows and three columns:
\describe{
  \item{wealth}{Wealth in billions of US dollars}
  \item{age}{Age of the billionaire}
   \item{region}{five regions:Asia, Europe, Middle East, United States, and Other}
}
}
\source{
Fortune magazine 1992.
}
\usage{
bill
}
\description{
Wealth, age and region of 225 billionaires in 1992 as reported in the 
Fortune magazine
}
\examples{
head(bill)
summary(bill)
library(ggplot2)
gg <- ggplot2::ggplot(data=bill, aes(x=age, y=wealth)) +
geom_point(aes(col=region, size=wealth)) + 
geom_smooth(method="loess", se=FALSE) + 
xlim(c(7, 102)) + 
ylim(c(1, 37)) + 
labs(subtitle="Wealth vs Age of Billionaires", 
y="Wealth (Billion US $)", x="Age", 
title="Scatterplot", caption = "Source: Fortune Magazine, 1992.")
plot(gg)
}
\keyword{datasets}
