% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.ipriorMod}
\title{Predict for I-prior models.}
\usage{
\method{predict}{ipriorMod}(object, newdata = list(), ...)
}
\arguments{
\item{object}{Objects of class \code{ipriorMod}.}

\item{newdata}{(optional) A data frame in which to look for variables with
  which to predict. If omitted, the fitted values are used.

  Note that when using non-formula to fit, the explanatory variables must be
  supplied in a list, such as \code{newdata = list(x1.new, x2.new, x3.new)}.}

\item{...}{This is not used here.}
}
\description{
Calculated predicted values of an I-prior model for a set of new data. If no
new data specified, then the fitted values are returned. When not using the
formula interface to fit the model, then the new data supplied for
\code{predict} must be coerced into a list.
}
\examples{
# Non-formula fit
\donttest{mod <- iprior(y = stack.loss,
                        air = stack.x[,1],
                        water = stack.x[,2],
                        acid = stack.x[,3])}
\donttest{predict(mod, newdata = list(air = 58, water = 20, acid = 87))}

# Formula fit
\donttest{mod.orange <- iprior(circumference ~ . ^ 2, data = Orange[-1, ])}
\donttest{predict(mod.orange, Orange[1, ])}

}

