% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_to_integer.R
\name{ip_to_integer}
\alias{ip_to_integer}
\alias{integer_to_ip}
\title{Represent address as integer}
\usage{
ip_to_integer(x)

integer_to_ip(x, is_ipv6 = NULL)
}
\arguments{
\item{x}{\itemize{
\item \code{ip_to_integer()}: An \code{\link{ip_address}} vector
\item \code{integer_to_ip()}: A \code{\link[bignum:biginteger]{bignum::biginteger}} vector
}}

\item{is_ipv6}{A logical vector indicating whether to construct an IPv4 or
IPv6 address. If \code{NULL} (the default), then IPv4 is preferred but an IPv6
address is constructed when \code{x} is too large for the IPv4 address space.}
}
\value{
\itemize{
\item \code{ip_to_integer()}: A \code{\link[bignum:biginteger]{bignum::biginteger}} vector
\item \code{integer_to_ip()}: An \code{\link{ip_address}} vector
}
}
\description{
Encode or decode an \code{\link{ip_address}} as an integer.
}
\details{
It is common to represent an IP address as an integer, by reinterpreting
the bit sequence as a big-endian unsigned integer. This means IPv4 and IPv6
addresses can be represented by 32-bit and 128-bit unsigned integers.
In this way, the IPv4 addresses \verb{0.0.0.0} and \verb{255.255.255.255} would be
represented as 0 and 4,294,967,295.

The numeric data types within base R (\code{\link{integer}} and \code{\link{double}}) have
insufficient precision to cover the IPv6 address space. Instead we return a
\code{\link[bignum:biginteger]{bignum::biginteger}} vector, which supports arbitrary precision integers.
}
\examples{
x <- ip_address(c("192.168.0.1", "2001:db8::8a2e:370:7334", NA))
ip_to_integer(x)

integer_to_ip(ip_to_integer(x))

# with IPv4 only, we can use numeric data type
as.numeric(ip_to_integer(ip_address("192.168.0.1")))

integer_to_ip(3232235521)
}
\seealso{
Other address representations: 
\code{\link{ip_to_binary}()},
\code{\link{ip_to_bytes}()},
\code{\link{ip_to_hex}()}
}
\concept{address representations}
