% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_address.R, R/ip_interface.R, R/ip_network.R
\name{ip_format}
\alias{ip_format}
\alias{format.ip_address}
\alias{format.ip_interface}
\alias{format.ip_network}
\title{Format IP vector}
\usage{
\method{format}{ip_address}(x, ..., exploded = FALSE)

\method{format}{ip_interface}(x, ..., exploded = FALSE)

\method{format}{ip_network}(x, ..., exploded = FALSE)
}
\arguments{
\item{x}{An object to format}

\item{...}{These dots are for future extensions and must be empty.}

\item{exploded}{Logical scalar. Should IPv6 addresses display leading zeros?
(default: \code{FALSE})}
}
\value{
A character vector
}
\description{
Format vector of IP data using compressed or exploded representation.
}
\examples{
format(ip_address("2001:db8::8a2e:370:7334"))

format(ip_address("2001:db8::8a2e:370:7334"), exploded = TRUE)
}
