% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_network.R
\name{ip_network}
\alias{ip_network}
\alias{ip_network.default}
\alias{ip_network.ip_address}
\alias{is_ip_network}
\alias{as_ip_network}
\alias{as_ip_network.character}
\alias{as_ip_network.ip_interface}
\alias{as.character.ip_network}
\alias{format.ip_network}
\title{Vector of IP networks}
\usage{
ip_network(...)

\method{ip_network}{default}(x = character(), strict = TRUE, ...)

\method{ip_network}{ip_address}(address, prefix_length, strict = TRUE, ...)

is_ip_network(x)

as_ip_network(x)

\method{as_ip_network}{character}(x)

\method{as_ip_network}{ip_interface}(x)

\method{as.character}{ip_network}(x, ...)

\method{format}{ip_network}(x, ...)
}
\arguments{
\item{...}{Included for S3 generic consistency}

\item{x}{\itemize{
\item For \code{ip_network()}: A character vector of IP networks, in CIDR notation
(IPv4 or IPv6)
\item For \code{is_ip_network()}: An object to test
\item For \code{as_ip_network()}: An object to cast
\item For \code{as.character()}: An \code{ip_network} vector
}}

\item{strict}{If \code{TRUE} (the default) and the input has host bits set,
then a warning is emitted and \code{NA} is returned. If \code{FALSE}, the
host bits are set to zero and a valid IP network is returned. If you need
to retain the host bits, consider using \code{\link[=ip_interface]{ip_interface()}} instead.}

\item{address}{An \code{\link{ip_address}} vector}

\item{prefix_length}{An integer vector}
}
\value{
An S3 vector of class \code{ip_network}
}
\description{
\code{ip_network()} constructs a vector of IP networks.

\code{is_ip_network()} checks if an object is of class \code{ip_network}.

\code{as_ip_network()} casts an object to \code{ip_network}.
}
\details{
An IP network corresponds to a contiguous range of IP addresses
(also known as an IP block). CIDR notation represents an
IP network as the routing prefix address (which denotes the start
of the range) and the prefix length (which indicates the size of
the range) separated by a forward slash. For example, \verb{192.168.0.0/24}
represents addresses from \verb{192.168.0.0} to \verb{192.168.0.255}.

The prefix length indicates the number of bits reserved by the
routing prefix. This means that larger prefix lengths indicate
smaller networks. The maximum prefix length is 32 for IPv4 and
128 for IPv6. These would correspond to an IP network of a single
IP address.

The \code{ip_network()} constructor accepts a character vector of IP networks
in CIDR notation. It checks whether each string is a valid IPv4 or IPv6
network, and converts it to an \code{ip_network} object. If the input is invalid,
a warning is emitted and \code{NA} is stored instead.

An alternative constructor accepts an \code{\link{ip_address}} vector and an
integer vector containing the network address and prefix length, respectively.

When casting an \code{ip_network} object back to a character vector using
\code{as.character()}, IPv6 addresses are reduced to their compressed representation.
}
\examples{
# construct from character vector
ip_network(c("192.168.0.0/24", "2001:db8::/48"))

# validates inputs and replaces with NA
ip_network(c("192.168.0.0/33", "192.168.0.0"))

# IP networks should not have any host bits set
ip_network("192.168.0.1/22")

# but we can mask the host bits if desired
ip_network("192.168.0.1/22", strict = FALSE)

# construct from address + prefix length
ip_network(ip_address("192.168.0.0"), 24L)

# construct from address + netmask
ip_network(ip_address("192.168.0.0"), prefix_length(ip_address("255.255.255.0")))

# construct from address + hostmask
ip_network(ip_address("192.168.0.0"), prefix_length(ip_address("0.0.0.255")))
}
\seealso{
\code{\link[=prefix_length]{prefix_length()}}, \code{\link[=network_address]{network_address()}}, \code{\link[=netmask]{netmask()}}, \code{\link[=hostmask]{hostmask()}}

\code{vignette("ipaddress-classes")}
}
