% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_linkages.R
\name{forward_linkages}
\alias{forward_linkages}
\title{Forward linkages}
\usage{
forward_linkages(output_coefficient_matrix, digits = NULL)
}
\arguments{
\item{output_coefficient_matrix}{An output coefficient matrix created with the 
\code{\link{output_coefficient_matrix_create}} function.}

\item{digits}{Number of decimals for rounding, defaults to \code{NULL}.}
}
\description{
Forward linkages as defined by the Eurostat Manual of Supply, Use and
Input-Output Tables (see p506-507.)
}
\examples{
data_table = iotable_get()

de_out <- output_coefficient_matrix_create ( 
 data_table, "tfu", digits = 4
 )

forward_linkages ( output_coefficient_matrix = de_out, 
                   digits = 4 )
}
