% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamorfosis.R
\name{metamorphosis}
\alias{metamorphosis}
\title{Transform data frame based in a dictionary}
\usage{
metamorphosis(fieldbook, dictionary, from, to, index, colnames)
}
\arguments{
\item{fieldbook}{Data frame with the original information.}

\item{dictionary}{Data frame with new names and categories. See details.}

\item{from}{Column of the dictionary with the original names.}

\item{to}{Column of the dictionary with the new names.}

\item{index}{Column of the dictionary with the type and level of the
variables.}

\item{colnames}{Character vector with the name of the columns.}
}
\value{
List with two objects. 1. New data frame. 2. Dictionary.
}
\description{
Transform entire fieldbook according to data a dictionary
}
\details{
The function require at least three columns.

  1. Original names (\code{from}).

  2. New names (\code{to}).

  3. Variable type (\code{index}).
}
\examples{

library(googlesheets4)
library(dplyr)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
, "1lslvNuebfI0YQw3KMz7clN8nIs3x8G9Da63E1em7J5o")
gs <- as_sheets_id(url)
# browseURL(url)

fb_old <- gs \%>\%
  range_read("fb_old") \%>\%
  select(ID:SNum) \%>\%
  filter(SS == "S1")

dic <- gs \%>\% range_read("var_old") \%>\%
  slice(1:20)

mtm <- metamorphosis(fieldbook = fb_old
                        , dictionary = dic
                        , from = "old_name"
                        , to = "Abbreviation"
                        , index = "Type"
                        , colnames = c("colname")
                     )

fb_new <- mtm$fieldbook

}

}
