% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interplex-package.r
\docType{package}
\name{interplex}
\alias{interplex}
\title{\strong{interplex} package}
\description{
This is a helper package to coerce simplicial complexes between
different data structures.
}
\details{
This package helps interface between different topological data analytic
packages and workflows by coercing simplicial complex objects stored using
different data structures. Each coercion is designed to retain as much
annotation as possible, whether of simplices or of the complex.

The package supports coercions between simplicial complexes stored using
the following data structures:
\itemize{
\item a complete list of simplices,
as stored as \code{cmplx} values of filtration objects
in \link[TDA:TDA-package]{the TDA package}
\item an object of class 'Rcpp_SimplexTree'
as implemented
in \link[simplextree:simplextree-package]{the simplextree package}
\item an object of class 'gudhi.simplex_tree.SimplexTree'
as implemented in \href{https://gudhi.inria.fr/python/latest/}{Python GUDHI}
and imported via \link[reticulate:reticulate]{reticulate}
\item an 'igraph' object,
as implemented
in \link[igraph:aaa-igraph-package]{the igraph package}
\item a 'network' object,
as implemented
in \link[network:network-package]{the network package}
}
}
