% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{convertedRate}
\alias{convertedRate}
\title{Scheduling interim analyses in clinical trials}
\usage{
convertedRate(r, w1, w2)
}
\arguments{
\item{r}{rate between 0 and 1 (0 < r < 1)}

\item{w1}{number of weeks for which r is defined}

\item{w2}{number of weeks to which the rate shall be converted}
}
\value{
The converted drop-out rate.
}
\description{
Function \code{convertedRate} converts a drop-out rate from one period to another. If the drop-out rate is defined for
w1 weeks \code{convertedRate} yields the drop-out rate for w2 weeks.
}
\details{
\code{convertedRate} is an auxilliary function that converts drop-out rates for different time periods.

The function can be used in order to convert drop-out rates required for function \code{treatment}. Function
\code{treatment} requires the drop-out rate for the respective treatment duration as input. Typically known annual
drop-out rates can be converted to the respective rate for the treatment duration accordingly by setting \code{w1}
to 52 and \code{w2} to the respective treatment duration.
}
\examples{
convertedRate(r=0.3,w1=52,w2=26)
}
\seealso{
\code{\link{treatment}} for simulating the treatment duration for a given recruitment scenario
}
