% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interacCircos.R
\name{CircosAuxLine}
\alias{CircosAuxLine}
\title{Create a AUXILIAYLINE module to a moduleList}
\usage{
CircosAuxLine(
  modulename,
  startX = 20,
  startY = 20,
  endX = 120,
  endY = 120,
  color = "red",
  width = 0.5,
  type = "straight",
  controlPointX = 0,
  controlPointY = 0,
  lineType = "solid",
  dashArray = 3,
  marker = TRUE,
  markerType = "circle",
  markerColor = "blue",
  markerHeight = 5,
  markerWidth = 5,
  markerPosition = 2,
  animationDisplay = FALSE,
  animationTime = 50,
  animationDelay = 1000,
  animationType = "linear",
  ...
)
}
\arguments{
\item{modulename}{The name of the new module.}

\item{startX, startY}{Start coordinates for auxiliary line.}

\item{endX, endY}{End coordinates for auxiliary line.}

\item{color}{Color for auxiliary line}

\item{width}{Width for auxiliary line}

\item{type}{Type for auxiliary line, could be straight/curve/broken}

\item{controlPointX, controlPointY}{The middle point coordinates for curve and broken}

\item{lineType}{Line type, could be solid/dot}

\item{dashArray}{The dash gap width}

\item{marker}{Whether display a marker on the end of line}

\item{markerType}{Type of marker, could be circle/square/arrow/stub}

\item{markerColor, markerHeight, markerWidth}{Color, Height and Width for marker}

\item{markerPosition}{1 means start, 2 means end, 3 means both}

\item{animationDisplay}{whether display animation}

\item{animationTime, animationDelay, animationType}{The time, delay and display type for animation}

\item{...}{Ignored}
}
\value{
The module tracks for auxliary line modules.
}
\description{
A auxiliary line displayed in the visualization
}
\examples{
Circos(CircosAuxLine('AuxLine01'))

}
