\name{ssaOptim}
\alias{ssaOptim}
\title{ Spatial simulated annealing for optimized model based mapping}
\description{
nDiff measurement stations will be optimally 
Optimization of measurement network with Spatial simulated annealing and MUKV
}
\usage{
ssaOptim(observations, predGrid, candidates, action, nDiff, model,
nr_iterations, plotOptim = TRUE, formulaString = NULL, coolingFactor = nr_iterations/10,
covariates = "over", ...)
}
\arguments{
\item{observations}{ Data frame with x,y coordinates of observations and possible covariates }
\item{predGrid}{ Data frame with x,y coordinates of prediction locations when \code{method} is "ssa" }
\item{candidates}{ When action is "add", candidates is data frame with x,y coordinates or a 
\code{\link[sp:SpatialPolygons]{SpatialPolygonsDataFrame}} }
\item{action}{ Character string indicating which type of action to simulate: 
"add" to add new measurement stations to the existing network or "del" to turn off existing stations }
\item{nDiff}{ Number of stations to add or delete }
\item{model}{ Variogram model:object of class \code{variogramModel},
         as generated by \code{\link[gstat:vgm]{vgm}}}
\item{nr_iterations}{ number of iterations before stoping }
\item{plotOptim}{ plot or not the result; TRUE by default }
\item{formulaString}{formula that defines the dependent variable as a linear model 
      of independent variables; suppose the dependent variable has name \code{z}, 
      for ordinary and simple kriging use the formula \code{z~1}; 
      for universal kriging, suppose \code{z} is linearly dependent on 
      \code{x} and \code{y}, use the formula \code{z~x+y}. The formulaString defaults
      to \code{"value~1"} if \code{value} is a part of the data set. 
      If not, the first column of the data set is used. }
\item{coolingFactor}{variable defining how fast ssa-algorithm should cool down.
      Smaller numbers give quicker cooling, higher numbers give slower cooling}
\item{covariates}{variable defining whether possible covariates should be found 
         by "over" or "krige", see also details below}
\item{...}{ other arguments to be passed on lower level functions }
}


\details{
This function applies SSA algorithm for the special case of optimization criterion MUKV. With covariates, 
the function takes a universal kriging model into account. Stopping criterion of the optimization procedure 
uses a number of searching steps without improvement in the design.

It is possible to assume a linear relationship between 
      independent and dependent variables (observations or spatial locations), as in 
      \code{\link[gstat:krige]{krige}}.
      However, a correct estimate of the mean universal kriging variance in the 
      prediction grid requires that the independent variables are known 
      at the candidate locations. This is not possible (except for the spatial
      locations themselves), these are instead estimated
      from the prediction locations.
      This is an approximation that might influence the criterion used for optimization,
      with increasing number of points added. This method can also slow down optimization.
      There are two possible methods for this that can be set with the argument \code{covariates}: 
      \code{\link[sp]{over}} and \code{\link[gstat]{krige}}.
      The first one finds the covariates of new locations from overlaying the prediction grid, 
      taking the value of 
      the nearest neighbour. The second method uses kriging to estimate the values of the 
      covariates at the new locations. The first method is generally faster, the second
      method most likely more exact, and particularly if the resolution of the prediction grid is low
      compared to the spatial correlation lengths of the covariates. 

}

\value{
Data frame of optimized locations
}

\references{
\url{http://www.intamap.org/}
}
\author{ Olivier Baume }
\keyword{spatial}
