% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmWorkflow.R
\name{sdmWorkflow}
\alias{sdmWorkflow}
\title{\code{sdmWorkflow}: Function to compile the reproducible workflow.}
\usage{
sdmWorkflow(
  Workflow = NULL,
  predictionDim = c(150, 150),
  predictionData = NULL,
  initialValues = FALSE,
  inlaOptions = list(),
  ipointsOptions = NULL
)
}
\arguments{
\item{Workflow}{The \code{R6} object created from \code{startWorkflow}. This object should contain all the data and model information required to estimate and specify the model.}

\item{predictionDim}{The pixel dimensions for the prediction maps. Defaults to \code{c(150, 150)}.}

\item{predictionData}{Optional argument for the user to specify their own data to predict on. Must be a \code{sf} or \code{SpatialPixelsDataFrame} object. Defaults to \code{NULL}.}

\item{initialValues}{Find initial values using a GLM before the model is estimated. Defaults to \code{FALSE}.}

\item{inlaOptions}{Options to specify in \link[INLA]{inla} from the \code{inla} function. See \code{?inla} for more details.}

\item{ipointsOptions}{Options to specify in \link[inlabru]{fm_int}'s \code{int.args} argument. See \code{?fmesher::fm_int} for more details.}
}
\value{
The return of the function depends on the argument \code{Save} from the \code{startWorkflow} function. If this argument is \code{FALSE} then the objects will be saved to the specidfied directory. If this argument is \code{TRUE} then a list of different outcomes from the workflow will be returned.
}
\description{
This function is used to compile the reproducible workflow from the \code{R6} object created with \code{startFunction}. Depending on what was specified before, this function will estimate the integrated species distribution model, perform cross-validation, create predictions from the model and plot these predictions.
}
\examples{
\dontrun{
if (requireNamespace('INLA')) {

workflow <- startWorkflow(Species = 'Fraxinus excelsior',
                          Projection = '+proj=longlat +ellps=WGS84',
                          Save = FALSE,
                          saveOptions = list(projectName = 'example'))
workflow$addArea(countryName = 'Sweden')

workflow$addGBIF(datasetName = 'exampleGBIF',
                 datasetType = 'PA',
                 limit = 10000,
                 coordinateUncertaintyInMeters = '0,50')
workflow$addMesh(cutoff = 20000,
                 max.edge=c(60000, 80000),
                 offset= 100000)
workflow$workflowOutput('Model')

Model <- sdmWorkflow(workflow)

}
}
}
