% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows_per_date.R
\name{rows_per_date}
\alias{rows_per_date}
\title{Find active rows per date}
\usage{
rows_per_date(df, dates, begin, end)
}
\arguments{
\item{df}{data.frame}

\item{dates}{vector of dates}

\item{begin}{column name in \code{df} with begin dates}

\item{end}{column name in \code{df} with end dates}
}
\value{
returned class is equal to class of \code{df}
}
\description{
Find active rows per date.
}
\examples{
library(lubridate)
portfolio <- data.frame(
begin1 = ymd(c("2014-01-01", "2014-01-01")),
end = ymd(c("2014-03-14", "2014-05-10")),
termination = ymd(c("2014-03-14", "2014-05-10")),
exposure = c(0.2025, 0.3583),
premium =  c(125, 150))

active_date <- seq(ymd("2014-01-01"), ymd("2014-05-01"), by = "months")
rows_per_date(portfolio, active_date, begin = begin1, end = end)

}
\author{
Martin Haringa
}
