% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_6exposure_plot.R
\name{autoplot.univ_exposure}
\alias{autoplot.univ_exposure}
\title{Automatically create a ggplot for objects obtained from univariate_exposure()}
\usage{
\method{autoplot}{univ_exposure}(
  x,
  labels = TRUE,
  sort = FALSE,
  coord_flip = TRUE,
  dec.mark = ",",
  color_bg = "#E7B800"
)
}
\arguments{
\item{x}{univ_exposure object produced by \code{univariate_exposure()}}

\item{labels}{show labels with the exposure (default is TRUE)}

\item{sort}{sort (or order) risk factor into descending order by exposure (default is FALSE)}

\item{coord_flip}{flip cartesian coordinates so that horizontal becomes vertical, and vertical, horizontal (default is TRUE)}

\item{dec.mark}{control the format of the decimal point, as well as the mark between intervals before the decimal point, choose either "," (default) or "."}

\item{color_bg}{change the color of the histogram ("#E7B800" is default)}
}
\value{
a ggplot2 object
}
\description{
Takes an object produced by \code{univariate_exposure()}, and plots the exposure.
}
\examples{
library(ggplot2)
x <- univariate_exposure(MTPL2, area, exposure)
autoplot(x, sort = TRUE)
autoplot(x, coord_flip = FALSE)

}
