% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_checks.R
\name{two_col_check}
\alias{two_col_check}
\title{Check a column for data fidelity using criteria related to a second column.}
\usage{
two_col_check(colname1, colname2, data, fun, output = FALSE, stage = NULL,
  ...)
}
\arguments{
\item{colname1}{character string specifying the name of the column within
your dataframe that will be the subject of the checks.}

\item{colname2}{character string specifying the name of a second column to be
used in the check criteria.}

\item{data}{the dataframe containing the data.}

\item{fun}{the check function you'd like to apply to the data.}

\item{output}{logical. If FALSE, the function returns a dataframe containing
only records that failed the specified check. If TRUE, invisibly prints an
excel output file containing only the records that failed the specified
check.}

\item{stage}{An optional character string that can be used to specify the
stage of the checking process in which the check is occurring. Only useful
if output = TRUE. If a value is specified, a that value is prefixed to the
output file; if no value is given, no stage prefix is attached.}

\item{...}{arguments to be passed through to the function specified in
\code{fun}}
}
\value{
col_check(output = FALSE) returns a dataframe containing only records
  that failed the specified check.

col_check(output = TRUE) invisibly prints an excel output file
  containing only records that failed the specified check.
}
\description{
Check a column for data fidelity using criteria related to a second column.
}
\examples{
two_col_check("Var1", "Var2", dataset, less_than_equalto, output = FALSE)

two_col_check("Var2", "Var1", dataset, greater_than, output = TRUE,
   stage = "1-Reasonableness")

}

