#' @title Checks if an object is a regression model object
#' @name is_model
#'
#' @description Small helper that checks if a model is a regression model
#'   object.
#'
#' @param x An object.
#'
#' @return A logical, \code{TRUE} if \code{x} is a (supported) model object.
#'
#' @details This function returns \code{TRUE} if \code{x} is a model object.
#'
#' @examples
#' data(mtcars)
#' m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
#'
#' is_model(m)
#' is_model(mtcars)
#' @export
is_model <- function(x) {
  inherits(
    x,
    c(
      "aareg",
      "anova",
      "aov",
      "aovlist",
      "Arima",
      "bamlss",
      "bamlss.frame",
      "bayesx",
      "BBmm",
      "BBreg",
      "betareg",
      "BFBayesFactor",
      "bglmerMod",
      "biglm",
      "bigglm",
      "blavaan",
      "blmerMod",
      "bracl",
      "brglmFit",
      "brmsfit",
      "brmultinom",
      "btergm",
      "cch",
      "censReg",
      "cgam",
      "cgamm",
      "clm",
      "clm2",
      "clmm",
      "clmm2",
      "complmrob",
      "confusionMatrix",
      "coxme",
      "coxph",
      "crch",
      "crq",
      "drc",
      "emmGrid",
      "epi.2by2",
      "ergm",
      "feis",
      "felm",
      "fitdistr",
      "flexsurvreg",
      "gam",
      "Gam",
      "GAMBoost",
      "gamlr",
      "gamlss",
      "gamm",
      "gamm4",
      "garch",
      "gbm",
      "gee",
      "geeglm",
      "glimML",
      "glm",
      "glmaag",
      "glmbb",
      "glmboostLSS",
      "glmc",
      "glmdm",
      "glmdisc",
      "glmerMod",
      "glmlep",
      "glmmadmb",
      "glmmEP",
      "glmmfields",
      "glmmLasso",
      "glmmPQL",
      "glmmTMB",
      "glmnet",
      "glmrob",
      "glmRob",
      "gls",
      "gmnl",
      "gmm",
      "htest",
      "hurdle",
      "iv_robust",
      "ivreg",
      "lavaan",
      "lm",
      "lm_robust",
      "lme",
      "lmrob",
      "lmRob",
      "logistf",
      "loo",
      "LORgee",
      "lmodel2",
      "lqmm",
      "lrm",
      "manova",
      "mboostLSS",
      "mclogit",
      "mmclogit",
      "mcmc",
      "MCMCglmm",
      "mediate",
      "merMod",
      "mixed",
      "MixMod",
      "mjoint",
      "mle2",
      "mlm",
      "mlogit",
      "multinom",
      "mvr",
      "negbin",
      "nlrq",
      "nls",
      "ols",
      "orcutt",
      "plm",
      "plmm",
      "polr",
      "psm",
      "rdrobust",
      "ridgelm",
      "rjags",
      "rlm",
      "rlme",
      "rlmerMod",
      "rma",
      "rma.uni",
      "rms",
      "rq",
      "rqss",
      "slm",
      "speedlm",
      "speedglm",
      "stanmvreg",
      "stanreg",
      "survfit",
      "survreg",
      "survPresmooth",
      "svyglm",
      "svyolr",
      "tobit",
      "truncreg",
      "vgam",
      "vglm",
      "wbm",
      "wblm",
      "zeroinfl",
      "zerotrunc"
    )
  )
}
