% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{component_eval}
\alias{component_eval}
\title{Evaluate component values in predictor expressions}
\usage{
component_eval(main, group = NULL, replicate = NULL, .state = NULL)
}
\arguments{
\item{main, group, replicate}{Specification of where to evaluate a component.
The three inputs are passed on to the respective \code{bru_mapper} methods.}

\item{.state}{The internal component state. Normally supplied automatically
by the internal methods for evaluating inlabru predictor expressions.}
}
\value{
A vector of values for a component
}
\description{
In predictor expressions, \code{name_eval(...)} can be used to evaluate
the effect of a component called "name".
}
\examples{
\dontrun{
if (bru_safe_inla()) {
  mesh <- INLA::inla.mesh.2d(
    cbind(0, 0),
    offset = 2, max.edge = 0.25
  )
  spde <- INLA::inla.spde2.pcmatern(mesh,
    prior.range = c(0.1, 0.01),
    prior.sigma = c(2, 0.01)
  )
  data <- sp::SpatialPointsDataFrame(
    matrix(runif(10), 5, 2),
    data = data.frame(y = rnorm(5))
  )
  fit <- bru(y ~ -1 + field(coordinates, model = spde),
    family = "gaussian", data = data
  )
  pred <- predict(
    fit,
    data = data.frame(x = 0.5, y = 0.5),
    formula = ~ field_eval(cbind(x, y))
  )
}
}
}
