% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bru_safe_inla}
\alias{bru_safe_inla}
\title{Load INLA safely for examples and tests}
\usage{
bru_safe_inla(multicore = NULL, quietly = FALSE)
}
\arguments{
\item{multicore}{logical; if \code{TRUE}, multiple cores are allowed, and the
INLA \code{num.threads} option is not checked or altered.
If \code{FALSE}, forces \code{num.threads="1:1"}. Default: NULL, checks
if running in testthat or non-interactively, in which case sets
\code{multicore=FALSE}, otherwise \code{TRUE}.}

\item{quietly}{logical; if \code{TRUE}, prints diagnostic messages. Default: FALSE.}
}
\value{
logical; \code{TRUE} if INLA was loaded safely, otherwise FALSE
}
\description{
Loads the INLA package with \code{requireNamespace("INLA", quietly = TRUE)}, and
optionally checks and sets the multicore \code{num.threads} INLA option.
}
\examples{
\dontrun{
if (bru_safe_inla()) {
  # Run inla dependent calculations
}
}

}
