% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{spreading.score}
\alias{spreading.score}
\title{Spreading score}
\usage{
spreading.score(
  graph,
  vertices = V(graph),
  weights = NULL,
  directed = FALSE,
  mode = "all",
  loops = TRUE,
  d = 3,
  scale = "range",
  verbose = FALSE
)
}
\arguments{
\item{graph}{A graph (network) of the igraph class.}

\item{vertices}{A vector of desired vertices, which could be obtained by the V function.}

\item{weights}{Optional positive weight vector for calculating weighted betweenness centrality
of nodes as a requirement for calculation of spreading score. If the graph has a weight edge attribute,
then this is used by default. Weights are used to calculate weighted shortest paths,
so they are interpreted as distances.}

\item{directed}{Logical scalar, whether to directed graph is analyzed. This argument
is ignored for undirected graphs.}

\item{mode}{The mode of Spreading score depending on the directedness of the graph.
If the graph is undirected, the mode "all" should be specified.
Otherwise, for the calculation of Spreading score based on
incoming connections select "in" and for the outgoing connections select "out".
Also, if all of the connections are desired, specify the "all" mode. Default mode is set to "all".}

\item{loops}{Logical; whether the loop edges are also counted.}

\item{d}{The distance, expressed in number of steps from a given node (default=3). Distance
must be > 0. According to Morone & Makse (https://doi.org/10.1038/nature14604), optimal
results can be reached at d=3,4, but this depends on the size/"radius" of the network.
NOTE: the distance d is not inclusive. This means that nodes at a distance of 3 from
our node-of-interest do not include nodes at distances 1 and 2. Only 3.}

\item{scale}{Character string; the method used for scaling/normalizing the results. Options include 'range' (normalization within a 1-100 range), 
'z-scale' (standardization using the z-score), and 'none' (no data scaling). The default selection is 'range'. Opting for the 'range' method is 
suitable when exploring a single network, allowing you to observe the complete spectrum and distribution of node influences. In this case, there is 
no intention to establish a specific threshold for the outcomes. However, it is possible to identify and present the top spreading nodes 
based on their rankings. Conversely, the 'z-scale' option proves advantageous if the aim is to compare node influences across multiple networks or 
if there is a desire to establish a threshold (usually z-score > 1.645) for generating a list of the most spreading nodes without manual intervention.}

\item{verbose}{Logical; whether the accomplishment of different stages of the algorithm should be printed (default is FALSE).}
}
\value{
A numeric vector with Spreading scores.
}
\description{
This function calculates the Spreading score of the desired nodes from a graph.
Spreading score reflects the spreading potential of each node within a network and is
one of the major components of the IVI.
}
\examples{
\dontrun{
MyData <- coexpression.data
My_graph <- graph_from_data_frame(MyData)
GraphVertices <- V(My_graph)
Spreading.score <- spreading.score(graph = My_graph, vertices = GraphVertices,
                                   weights = NULL, directed = FALSE, mode = "all",
                                   loops = TRUE, d = 3, scale = "range")
}
}
\seealso{
\code{\link[influential]{cent_network.vis}}

Other integrative ranking functions: 
\code{\link{comp_manipulate}()},
\code{\link{exir}()},
\code{\link{hubness.score}()},
\code{\link{ivi.from.indices}()},
\code{\link{ivi}()}
}
\concept{integrative ranking functions}
\keyword{spreading.score}
