% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.from.vector.R
\name{incidence.from.vector}
\alias{incidence.from.vector}
\title{Generates an incidence matrix with given row and column marginal sums}
\usage{
incidence.from.vector(R, C, class = "matrix", narrative = FALSE)
}
\arguments{
\item{R}{numeric vector: row marginal sums}

\item{C}{numeric vector: column marginal sums}

\item{class}{string: the class of the returned backbone graph, one of c("matrix", "Matrix", "igraph").}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An incidence matrix of class \code{matrix} or \code{Matrix}, or a bipartite graph of class \link[igraph]{igraph}.
}
\description{
\code{incidence.from.vector} generates a random incidence matrix with given row and column sums
}
\examples{
I <- incidence.from.vector(R = c(1,1,2), C = c(1,1,2))
I <- incidence.from.vector(R = c(1,1,2), C = c(1,1,2),
     class = "igraph", narrative = TRUE)
}
\references{
{Neal, Z. P., Domagalski, R., and Sagan, B. 2021. Comparing alternatives to the fixed degree sequence model for extracting the backbone of bipartite projections. \emph{Scientific Reports, 11}, 23929. \doi{10.1038/s41598-021-03238-3}}

{Neal, Z. P. 2022. incidentally: An R package to generate incidence matrices and bipartite graphs. \emph{CRAN} \doi{10.32614/CRAN.package.incidentally}}
}
