% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.mean.R
\name{na.mean}
\alias{na.mean}
\title{Missing Value Imputation by Mean Value}
\usage{
na.mean(x, option = "mean")
}
\arguments{
\item{x}{Numeric Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object in which missing values shall be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"mean" - take the mean for imputation}
   \item{"median" - take the median for imputation}
   \item{"mode" - take the mode for imputation}
   }}
}
\value{
Vector (\code{\link{vector}}) or Time Series (\code{\link{ts}}) object (dependent on given input at parameter x)
}
\description{
Missing value replacement by mean values. Different means like median, mean, mode possible.
}
\details{
Missing values get replaced by overall mean values. The function calculates the mean, median or mode
over all the non-NA values and replaces all NAs with this value. Option 'mode' replaces NAs with the 
most frequent value in the time series. If two or more values occur equally frequent, the function imputes
with the lower value. That's why 'mode' is not the best option for decimal values.
}
\examples{
#Prerequisite: Create Time series with missing values
x <- ts(c(2,3,4,5,6,NA,7,8))

#Example 1: Perform imputation with the overall mean
na.mean(x)

#Example 2: Perform imputation with overall median
na.mean(x, option ="median")
}
\seealso{
\code{\link[imputeTS]{na.interpolation}},
\code{\link[imputeTS]{na.kalman}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.ma}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}},
 \code{\link[imputeTS]{na.seadec}}, \code{\link[imputeTS]{na.seasplit}}
}
\author{
Steffen Moritz
}
