% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.locf.R
\name{na.locf}
\alias{na.locf}
\title{Missing Value Imputation by LOCF}
\usage{
na.locf(data, option = "locf", na.identifier = NA, na.remaining = "keep")
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"locf" - for Last Observation Carried Forward}
   \item{"nocb" - for Next Obervation Carried Backward}
   }}

\item{na.identifier}{Missing Value Identifier. 
If another value than NA indicates missing values this can be specified here. 
Identifier can be a character string as well as a numeric value. No support for lists or vectors.}

\item{na.remaining}{Method to be used for remaining NAs.
\itemize{
   \item{"keep" - to return the series with NAs}
   \item{"rm" - to remove remaining NAs}
   \item{"mean" - to replace remaining NAs by overall mean}
   \item{"rev" - to perform nocb / locf from the reverse direction}
   }}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Replaces each missing value with the most recent present value prior to it
 (Last Observation Carried Forward- LOCF). Optionally this can also be done starting from the back of the series
 (Next Observation Carried Backward - NOCB).
}
\details{
Replaces each missing value with the most recent present value prior to it
 (Last Observation Carried Forward- LOCF). This can also be done from the reverse direction -starting from the back
 (Next Observation Carried Backward - NOCB). Both options have the issue, that NAs at the beginning 
 (or for nocb at the end) of the time series can not be imputed (since there is no last value to 
 be carried forward present yet). In this case there are remaining NAs in the imputed time series.
 Since this only concerns very few values at the beginning of the series,
  na.remaining offers some quick solutions to get a series without NAs back.
}
\examples{
#Create Time series with missing values
x <- ts(c(NA,3,4,5,6,NA,7,8))

#Perform LOCF
na.locf(x)

#Perform NOCF
na.locf(x, option = "nocb")

#Perform LOCF and replace remaining NAs by NOCB
na.locf(x, na.remaining = "rev")

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

