% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_impute_AR1_Gaussian.R
\name{impute_AR1_Gaussian}
\alias{impute_AR1_Gaussian}
\title{Impute missing values of time series based on a Gaussian AR(1) model}
\usage{
impute_AR1_Gaussian(
  y,
  n_samples = 1,
  impute_leading_NAs = FALSE,
  impute_trailing_NAs = FALSE,
  random_walk = FALSE,
  zero_mean = FALSE,
  return_estimates = FALSE,
  tol = 1e-10,
  maxiter = 1000
)
}
\arguments{
\item{y}{Time series object coercible to either a numeric vector or numeric matrix 
(e.g., \code{zoo} or \code{xts}) with missing values denoted by \code{NA}.}

\item{n_samples}{Positive integer indicating the number of imputations (default is \code{1}).}

\item{impute_leading_NAs}{Logical value indicating if the leading missing values of time 
series are to be imputed (default is \code{FALSE}).}

\item{impute_trailing_NAs}{Logical value indicating if the trailing missing values of time 
series are to be imputed (default is \code{FALSE}).}

\item{random_walk}{Logical value indicating if the time series is assumed to be a random walk so that \code{phi1 = 1} 
(default is \code{FALSE}).}

\item{zero_mean}{Logical value indicating if the time series is assumed zero-mean so that \code{phi0 = 0} 
(default is \code{FALSE}).}

\item{return_estimates}{Logical value indicating if the estimates of the model parameters 
are to be returned (default is \code{FALSE}).}

\item{tol}{Positive number denoting the relative tolerance used as stopping criterion (default is \code{1e-8}).}

\item{maxiter}{Positive integer indicating the maximum number of iterations allowed (default is \code{1000}).}
}
\value{
By default (i.e., for \code{n_samples = 1} and \code{return_estimates = FALSE}), 
        the function will return an imputed time series of the same class and dimensions 
        as the argument \code{y} with one new attribute recording the locations of missing 
        values (the function \code{\link{plot_imputed}} will make use of such information
        to indicate the imputed values).
        
        If \code{n_samples > 1}, the function will return a list consisting of \code{n_sample} 
        imputed time series with names: y_imputed.1, y_imputed.2, etc. 
        
        If \code{return_estimates = TRUE}, in addition to the imputed time series \code{y_imputed}, 
        the function will return the estimated model parameters:
        \item{\code{phi0}}{The estimate for \code{phi0} (numeric scalar or vector depending 
                           on the number of time series).}
        \item{\code{phi1}}{The estimate for \code{phi1} (numeric scalar or vector depending 
                           on the number of time series).}
        \item{\code{sigma2}}{The estimate for \code{sigma2} (numeric scalar or vector depending 
                             on the number of time series).}
}
\description{
Impute missing values of time series by drawing samples from 
             the conditional distribution of the missing values given the 
             observed data based on a Gaussian AR(1) model as estimated 
             with the function \code{\link{fit_AR1_Gaussian}}.
}
\examples{
library(imputeFin)
data(ts_AR1_Gaussian) 
y_missing <- ts_AR1_Gaussian$y_missing
y_imputed <- impute_AR1_Gaussian(y_missing)
plot_imputed(y_imputed)

}
\references{
R. J. Little and D. B. Rubin, Statistical Analysis with Missing Data, 2nd ed. Hoboken, N.J.: John Wiley & Sons, 2002.

J. Liu, S. Kumar, and D. P. Palomar, "Parameter estimation of heavy-tailed AR model with missing 
data via stochastic EM," IEEE Trans. on Signal Processing, vol. 67, no. 8, pp. 2159-2172, 15 April, 2019.
}
\author{
Junyan Liu and Daniel P. Palomar
}
