% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_sciat.R
\name{compute_sciat}
\alias{compute_sciat}
\title{Compute the D-score for the SC-IAT}
\usage{
compute_sciat(
  data,
  mappingA = "mappingA",
  mappingB = "mappingB",
  non_response = NULL
)
}
\arguments{
\item{data}{Data frame with class \code{clean_sciat}.}

\item{mappingA}{String. Label identifying the mapping A of the SC-IAT in the
\code{block_id} variable.}

\item{mappingB}{String. Label identifying the mapping B of the SC-IAT in the
\code{block_id} variable.}

\item{non_response}{String. Labels of the trials identifying the
non-responses, a.k.a responses beyond the response time
window, as it was specified in \code{trial_id} (if included).}
}
\value{
A dataframe with class \code{compute_sciat}. The number of rows of the
        dataframe corresponds to the total number of participants. Variables
        are defined as follows (the values are specific for each
         participant):

 \describe{
 \item{\code{participant}}{Respondents' IDs.}
 \item{\code{n_trial}}{Number of trial before data cleaning.}
 \item{\code{no_response}}{If there were any trials identifying the non
                response, it indicates the number of non responses per each
                participant. Otherwise, it is equal for all participants
                (\code{"none"}).}
 \item{\code{nslow10000}}{Number of slow trials (> 10,000 ms).}
 \item{\code{out_accuracy}}{Indicates whether the participants had more
                than 25 \% of incorrect responses in at least one of the
                critical blocks and hence should be eliminated (\code{"out"})
                or not (\code{"keep"}).}
 \item{\code{nfast400}}{Number of fast trials (< 400 ms).}
 \item{\code{nfast300}}{Number of fast trials (< 350 ms -- deleted).}
 \item{\code{accuracy.mappingA}}{Proportion of correct responses in Mapping A.}
 \item{\code{accuracy.mappingB}}{Proportion of correct responses in mapping B.}
 \item{\code{RT_mean.MappingA}}{Mean response time in Mapping A.}
 \item{\code{RT_mean.MappingB}}{Mean response time in Mapping B.}
 \item{\code{cond_ord}}{Indicates the order with which the associative
                 conditions have been presented, either \code{"MappingA_First"} or
                 \code{"MappingB_First"}.}
 \item{\code{legendMappingA}}{Indicates the corresponding value of Mapping A
    in the original dataset.}
 \item{\code{legendMappingB}}{Indicates the corresponding value of Mapping B
    in the original dataset.}
 \item{\code{d_sciat}}{SC-IAT \emph{D}.}
 }
}
\description{
Compute the D-score for the SC-IAT.
}
\examples{
# calculate D for the SCIAT
  data("raw_data") # load data
sciat_data <- clean_sciat(raw_data, sbj_id = "Participant",
                         block_id = "blockcode",
                         latency_id = "latency",
                         accuracy_id = "correct",
                         block_sciat_1 = c("test.sc_dark.Darkbad",
                                           "test.sc_dark.Darkgood"),
                         block_sciat_2 = c("test.sc_milk.Milkbad",
                                           "test.sc_milk.Milkgood"),
                         trial_id  = "trialcode",
                         trial_eliminate = c("reminder",
                                             "reminder1"))
 sciat1 <- sciat_data[[1]] # compute D for the first SC-IAT
 d_sciat1 <- compute_sciat(sciat1,
                    mappingA = "test.sc_dark.Darkbad",
                    mappingB = "test.sc_dark.Darkgood",
                    non_response = "alert")
 head(d_sciat1) # dataframe containing the SC-IAT D of the of the
                # first SC-IAT

 sciat2 <- sciat_data[[2]] # Compute D for the second SC-IAT
 d_sciat2 <- compute_sciat(sciat2,
                    mappingA = "test.sc_milk.Milkbad",
                    mappingB = "test.sc_milk.Milkgood",
                    non_response = "alert")
 head(d_sciat2)
}
