% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_plot.R
\name{d_plot}
\alias{d_plot}
\title{Plot either IAT or SC-IAT scores (points)}
\usage{
d_plot(data, point_size = 1, x_label = "Participant",
  x_values = TRUE, order_sbj = c("default", "D-increasing",
  "D-decreasing"), col_point = "springgreen4", include_stats = FALSE)
}
\arguments{
\item{data}{Dataframe with either class \code{dscore} or \code{dsciat}.}

\item{point_size}{Numeric. Indicates the size of the points in the graph.
Default is 1.}

\item{x_label}{Character. Label of the x-axis. Default is \code{Participant}.}

\item{x_values}{Logical. Shows the values for x-axis (default = \code{TRUE}).}

\item{order_sbj}{Character. Defines the order with which the participants are
displayed. Default is the default order of participants in
the dataframe.}

\item{col_point}{Character. Defines the color of the points. Default is
\code{"springgreen4"}.}

\item{include_stats}{Logical. Indicates whether to add descriptive statistics.
The \code{mean} is depicted with a solid line. The two
dashed lines represent +/2 \emph{s.d.} from the mean.
Default is \code{FALSE}.}
}
\value{
A ggplot object
}
\description{
Plot the individual \emph{D-score} or SC-IAT \emph{D}.
}
\examples{
\donttest{
# Plotting the IAT D-score
  data("raw_data") # import data
  iat_cleandata <- clean_iat(raw_data, sbj_id = "Participant",
                          block_id = "blockcode",
                          mapA_practice = "practice.iat.Milkbad",
                          mapA_test = "test.iat.Milkbad",
                          mapB_practice = "practice.iat.Milkgood",
                          mapB_test = "test.iat.Milkgood",
                          latency_id = "latency",
                          accuracy_id = "correct",
                          trial_id = "trialcode",
                          trial_eliminate = c("reminder", "reminder1"),
                          demo_id = "blockcode",
                          trial_demo = "demo")
  iat_data <- iat_cleandata[[1]]
# calculate D-score
  iat_dscore <- computeD(iat_data,
                       Dscore =  "d2")
  d_plot(iat_dscore) # default plot
  d_plot(iat_dscore, order_sbj = "D-increasing") # D-score with increasing
                                                 # order
  d_plot(iat_dscore, order_sbj = "D-decreasing",
         col_point = "salmon") # D-score with decreasing order changed color
# Plot the SC-IAT D for the first SC-IAT
  data("raw_data") # load data
  sciat_data <- clean_sciat(raw_data, sbj_id = "Participant",
                         block_id = "blockcode",
                         latency_id = "latency",
                         accuracy_id = "correct",
                         block_sciat_1 = c("test.sc_dark.Darkbad",
                                           "test.sc_dark.Darkgood"),
                         block_sciat_2 = c("test.sc_milk.Milkbad",
                                           "test.sc_milk.Milkgood"),
                         trial_id  = "trialcode",
                         trial_eliminate = c("reminder",
                                             "reminder1"))

 sciat1 <- sciat_data[[1]] # compute D for the first SC-IAT
 d_sciat1 <- Dsciat(sciat1,
                  mappingA = "test.sc_dark.Darkbad",
                  mappingB = "test.sc_dark.Darkgood",
                  non_response = "alert")
  d_plot(d_sciat1, col_point = "salmon",
          include_stats = TRUE) # SC-IAT D with descriptive statistics
          }
}
