% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{list_germline_genes_allele_01}
\alias{list_germline_genes_allele_01}
\title{Collection of germline genes and frequencies}
\format{A list of lists containing dataframes with up to 126 entries:
\describe{
  \item{gene}{name of germline gene}
  \item{allele}{allele number (presently restricted to allele 01)}
  \item{sequence}{nucleotide sequence of germline gene}
  \item{species}{name of species}
  \item{frequency}{Frequencies of germline genes based on experimental data}
}}
\source{
{
   \url{http://www.imgt.org/vquest/refseqh.html}

   \url{https://doi.org/10.1371/journal.pone.0160853}

   \url{https://doi.org/10.1038/ng.3822}

   \url{https://doi.org/10.1016/j.celrep.2017.04.054}

   \url{https://doi.org/10.7554/eLife.22057}
   }
}
\usage{
list_germline_genes_allele_01
}
\description{
A list containing sublists for species ("hs","mm") which in turn
contain sublists for receptors ("ig","tr") which are subset in
chains ("h", "k", "l" and "b", "a", respectively). Each entry
contains a list of three dataframes ("V","D" and "J") with the major IMGT
annotated germline genes including name, sequence based on IMGT and frequencies based on
experimental data from DeWitt(2017), Emerson (2017), Greiff (2017) and Madi (2017)
}
\keyword{datasets}
