% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hough.R
\name{nfline}
\alias{nfline}
\title{Plot a line, Hesse normal form parameterisation}
\usage{
nfline(theta, rho, col, ...)
}
\arguments{
\item{theta}{angle (radians)}

\item{rho}{distance}

\item{col}{colour}

\item{...}{other graphical parameters, passed along to abline}
}
\value{
nothing
}
\description{
This is a simple interface over abline meant to be used along with the Hough transform.  In the Hesse normal form (theta,rho), a line is represented as the set of values (x,y) such that cos(theta)*x + sin(theta)*y = rho. Here theta is an angle and rho is a distance.
See the documentation for hough_lines.
}
\examples{
\dontshow{cimg.limit.openmp()}
#Boring example, see ?hough_lines
plot(boats)
nfline(theta=0,rho=10,col="red")
}
\author{
Simon Barthelme
}
