% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{imrotate}
\alias{imrotate}
\title{Rotate an image along the XY plane.}
\usage{
imrotate(im, angle, cx, cy, interpolation = 1L, boundary = 0L)
}
\arguments{
\item{im}{an image}

\item{angle}{Rotation angle, in degrees.}

\item{cx}{Center of rotation along x (default, image centre)}

\item{cy}{Center of rotation along y (default, image centre)}

\item{interpolation}{Type of interpolation. One of 0=nearest,1=linear,2=cubic.}

\item{boundary}{Boundary conditions. One of 0=dirichlet, 1=neumann, 2=periodic}
}
\description{
If cx and cy aren't given, the default is to centre the rotation in the middle of the image. When cx and cy are given, the algorithm used is different, and does not change the size of the image.
}
\examples{
imrotate(boats,30) \%>\% plot
#Shift centre to (20,20)
imrotate(boats,30,cx=20,cy=20) \%>\% plot 
}
\seealso{
imwarp, for flexible image warping, which includes rotations as a special case
}
