% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textlinedetector.R
\name{image_textlines_crop}
\alias{image_textlines_crop}
\title{Crop an image to extract only the region containing text}
\usage{
image_textlines_crop(x)
}
\arguments{
\item{x}{an object of class magick-image}
}
\value{
an object of class magick-image
}
\description{
Applies a sequence of image operations to obtain a region which contains relevant texts
by cropping white space on the borders of the image.
This is done in the following steps:
morphological opening, morphological closing, blurring, canny edge detection, convex hull contours of the edges, 
keep only contours above the mean contour area, find approximated contour lines of the convex hull contours of these, 
dilation and thresholding.
}
\examples{
\donttest{
library(opencv)
library(magick)
library(image.textlinedetector)
path  <- system.file(package = "image.textlinedetector", "extdata", "example.png")
img   <- image_read(path)
image_info(img)
img   <- image_textlines_crop(img)
image_info(img)
}
}
