% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flow.R
\name{max_flow}
\alias{max_flow}
\title{Maximum flow in a graph}
\usage{
max_flow(graph, source, target, capacity = NULL)
}
\arguments{
\item{graph}{The input graph.}

\item{source}{The id of the source vertex.}

\item{target}{The id of the target vertex (sometimes also called sink).}

\item{capacity}{Vector giving the capacity of the edges. If this is
\code{NULL} (the default) then the \code{capacity} edge attribute is used.
Note that the \code{weight} edge attribute is not used by this function.}
}
\value{
A named list with components:
\item{value}{A numeric scalar, the value of the maximum flow.}
\item{flow}{A numeric vector, the flow itself, one entry for each
edge. For undirected graphs this entry is bit trickier, since for
these the flow direction is not predetermined by the edge
direction. For these graphs the elements of the this vector can be
negative, this means that the flow goes from the bigger vertex id to
the smaller one. Positive values mean that the flow goes from
the smaller vertex id to the bigger one.}
\item{cut}{A numeric vector of edge ids, the minimum cut corresponding
to the maximum flow.}
\item{partition1}{A numeric vector of vertex ids, the vertices in the
first partition of the minimum cut corresponding to the maximum
flow.}
\item{partition2}{A numeric vector of vertex ids, the vertices in the
second partition of the minimum cut corresponding to the maximum
flow.}
\item{stats}{A list with some statistics from the push-relabel
algorithm. Five integer values currently: \code{nopush} is the
number of push operations, \code{norelabel} the number of
relabelings, \code{nogap} is the number of times the gap heuristics
was used, \code{nogapnodes} is the total number of gap nodes omitted
because of the gap heuristics and \code{nobfs} is the number of
times a global breadth-first-search update was performed to assign
better height (=distance) values to the vertices.}
}
\description{
In a graph where each edge has a given flow capacity the maximal flow
between two vertices is calculated.
}
\details{
\code{max_flow()} calculates the maximum flow between two vertices in a
weighted (i.e. valued) graph. A flow from \code{source} to \code{target} is
an assignment of non-negative real numbers to the edges of the graph,
satisfying two properties: (1) for each edge the flow (i.e. the assigned
number) is not more than the capacity of the edge (the \code{capacity}
parameter or edge attribute), (2) for every vertex, except the source and
the target the incoming flow is the same as the outgoing flow. The value of
the flow is the incoming flow of the \code{target} vertex. The maximum flow
is the flow of maximum value.
}
\examples{

E <- rbind(c(1, 3, 3), c(3, 4, 1), c(4, 2, 2), c(1, 5, 1), c(5, 6, 2), c(6, 2, 10))
colnames(E) <- c("from", "to", "capacity")
g1 <- graph_from_data_frame(as.data.frame(E))
max_flow(g1, source = V(g1)["1"], target = V(g1)["2"])
}
\references{
A. V. Goldberg and R. E. Tarjan: A New Approach to the Maximum
Flow Problem \emph{Journal of the ACM} 35:921-940, 1988.
}
\seealso{
Other flow: 
\code{\link{dominator_tree}()},
\code{\link{edge_connectivity}()},
\code{\link{is_min_separator}()},
\code{\link{is_separator}()},
\code{\link{min_cut}()},
\code{\link{min_separators}()},
\code{\link{min_st_separators}()},
\code{\link{st_cuts}()},
\code{\link{st_min_cuts}()},
\code{\link{vertex_connectivity}()}
}
\concept{flow}
