% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_hierarchical_sbm}
\alias{sample_hierarchical_sbm}
\alias{hierarchical_sbm}
\title{Sample the hierarchical stochastic block model}
\usage{
sample_hierarchical_sbm(n, m, rho, C, p)

hierarchical_sbm(...)
}
\arguments{
\item{n}{Integer scalar, the number of vertices.}

\item{m}{Integer scalar, the number of vertices per block. \code{n / m} must
be integer. Alternatively, an integer vector of block sizes, if not all the
blocks have equal sizes.}

\item{rho}{Numeric vector, the fraction of vertices per cluster, within a
block. Must sum up to 1, and \code{rho * m} must be integer for all elements
of rho. Alternatively a list of rho vectors, one for each block, if they are
not the same for all blocks.}

\item{C}{A square, symmetric numeric matrix, the Bernoulli rates for the
clusters within a block. Its size must mach the size of the \code{rho}
vector. Alternatively, a list of square matrices, if the Bernoulli rates
differ in different blocks.}

\item{p}{Numeric scalar, the Bernoulli rate of connections between vertices
in different blocks.}

\item{...}{Passed to \code{sample_hierarchical_sbm()}.}
}
\value{
An igraph graph.
}
\description{
Sampling from a hierarchical stochastic block model of networks.
}
\details{
The function generates a random graph according to the hierarchical
stochastic block model.
}
\examples{

## Ten blocks with three clusters each
C <- matrix(c(
  1, 3 / 4, 0,
  3 / 4, 0, 3 / 4,
  0, 3 / 4, 3 / 4
), nrow = 3)
g <- sample_hierarchical_sbm(100, 10, rho = c(3, 3, 4) / 10, C = C, p = 1 / 20)
g
if (require(Matrix)) {
  image(g[])
}
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()},
\code{\link{sample_}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
