% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/make.R
\name{make_tree}
\alias{graph.tree}
\alias{make_tree}
\alias{tree}
\title{Create tree graphs}
\usage{
make_tree(n, children = 2, mode = c("out", "in", "undirected"))

tree(...)
}
\arguments{
\item{n}{Number of vertices.}

\item{children}{Integer scalar, the number of children of a vertex
(except for leafs)}

\item{mode}{Defines the direction of the
edges. \code{out} indicates that the edges point from the parent to
the children, \code{in} indicates that they point from the children
to their parents, while \code{undirected} creates an undirected
graph.}

\item{...}{Passed to \code{make_tree}.}
}
\value{
An igraph graph
}
\description{
Create a regular tree graph.
}
\examples{
make_tree(10, 2)
make_tree(10, 3, mode = "undirected")
}
\seealso{
Other determimistic constructors: \code{\link{atlas}},
  \code{\link{graph.atlas}},
  \code{\link{graph_from_atlas}};
  \code{\link{chordal_ring}},
  \code{\link{graph.extended.chordal.ring}},
  \code{\link{make_chordal_ring}};
  \code{\link{directed_graph}}, \code{\link{graph}},
  \code{\link{graph.famous}},
  \code{\link{make_directed_graph}},
  \code{\link{make_graph}},
  \code{\link{make_undirected_graph}},
  \code{\link{undirected_graph}};
  \code{\link{empty_graph}}, \code{\link{graph.empty}},
  \code{\link{make_empty_graph}};
  \code{\link{from_edgelist}},
  \code{\link{graph.edgelist}},
  \code{\link{graph_from_edgelist}};
  \code{\link{from_literal}}, \code{\link{graph.formula}},
  \code{\link{graph_from_literal}};
  \code{\link{full_citation_graph}},
  \code{\link{graph.full.citation}},
  \code{\link{make_full_citation_graph}};
  \code{\link{full_graph}}, \code{\link{graph.full}},
  \code{\link{make_full_graph}};
  \code{\link{graph.lattice}}, \code{\link{lattice}},
  \code{\link{make_lattice}}; \code{\link{graph.ring}},
  \code{\link{make_ring}}, \code{\link{ring}};
  \code{\link{graph.star}}, \code{\link{make_star}},
  \code{\link{star}}
}
\concept{
Trees.
}

