% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/community.R
\name{contract}
\alias{contract}
\alias{contract.vertices}
\title{Contract several vertices into a single one}
\usage{
contract(graph, mapping, vertex.attr.comb = igraph_opt("vertex.attr.comb"))
}
\arguments{
\item{graph}{The input graph, it can be directed or undirected.}

\item{mapping}{A numeric vector that specifies the mapping. Its elements
correspond to the vertices, and for each element the id in the new graph is
given.}

\item{vertex.attr.comb}{Specifies how to combine the vertex attributes in
the new graph. Please see \code{\link{attribute.combination}} for details.}
}
\value{
A new graph object.
}
\description{
This function creates a new graph, by merging several vertices into one. The
vertices in the new graph correspond to sets of vertices in the input graph.
}
\details{
The attributes of the graph are kept. Graph and edge attributes are
unchanged, vertex attributes are combined, according to the
\code{vertex.attr.comb} parameter.
}
\examples{
g <- make_ring(10)
g$name <- "Ring"
V(g)$name <- letters[1:vcount(g)]
E(g)$weight <- runif(ecount(g))

g2 <- contract(g, rep(1:5, each=2),
                        vertex.attr.comb=toString)

## graph and edge attributes are kept, vertex attributes are
## combined using the 'toString' function.
print(g2, g=TRUE, v=TRUE, e=TRUE)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}

