% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_metrics.R
\name{all_metrics}
\alias{all_metrics}
\title{Calculate all metrics in iglu}
\usage{
all_metrics(
  data,
  dt0 = NULL,
  inter_gap = 45,
  tz = "",
  timelag = 15,
  lag = 1,
  metrics_to_include = c("all", "consensus_only")
)
}
\arguments{
\item{data}{DataFrame object with column names "id", "time", and "gl".}

\item{dt0}{The time frequency for interpolation in minutes, the default will match the CGM meter's frequency (e.g. 5 min for Dexcom).}

\item{inter_gap}{The maximum allowable gap (in minutes) for interpolation. The values will not be interpolated between the glucose measurements that are more than inter_gap minutes apart. The default value is 45 min.}

\item{tz}{A character string specifying the time zone to be used. System-specific (see \code{\link{as.POSIXct}}), but " " is the current time zone, and "GMT" is UTC (Universal Time, Coordinated). Invalid values are most commonly treated as UTC, on some platforms with a warning.}

\item{timelag}{Integer indicating the time period (# minutes) over which rate
of change is calculated. Default is 15, e.g. rate of change is the change in
glucose over the past 15 minutes divided by 15.}

\item{lag}{Integer indicating which lag (# days) to use. Default is 1.}

\item{metrics_to_include}{Returns all metrics computed by iglu or all on the consensus list (Battelino 2023)}
}
\value{
A tibble object with 1 row per subject and one column per metric is returned.
}
\description{
The function all_metrics runs all of the iglu metrics, and returns the results with
one column per metric.
}
\details{
All iglu functions are calculated within the all_metrics function, and the resulting tibble
is returned with one row per subject and a column for each metric. Time dependent functions are
calculated together using the function optimized_iglu_functions with two exceptions:
PGS and episodes are calculated within all_metrics because their structure does not
align with optimized_iglu_functions. Note that episodes related outputs included in all_metrics are only
average episodes per day. To get the average duration and glucose, please use the standalone
episodes function

For metric specific information, please see the corresponding function documentation.
}
\examples{
data(example_data_1_subject)
all_metrics(example_data_1_subject)

}
\references{
Battelino T, Alexander CM, Amiel SA, et al. Continuous glucose monitoring and metrics for clinical trials: an international consensus statement.
\emph{Lancet Diabetes Endocrinol.}  \strong{2023;11(1):}42-57.
\doi{10.1016/S2213-8587(22)00319-9}.

# Specify the meter frequency and change the interpolation gap to 30 min
all_metrics(example_data_1_subject, dt0 = 5, inter_gap = 30)
}
