% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampler.r
\docType{class}
\name{sampler_iglm_generator}
\alias{sampler_iglm_generator}
\alias{sampler_iglm}
\title{R6 Class for iglm Sampler Settings}
\description{
The `sampler_iglm` class is an R6 container for specifying and storing
the parameters that control the MCMC (Markov Chain Monte Carlo) sampling
process used in \code{\link{iglm}} simulations and potentially during estimation.
It includes settings for the number of simulations, burn-in period,
initialization, and
parallelization options. It also holds references to component samplers
(\code{\link{sampler.net_attr}} objects) responsible for sampling individual parts
(attributes x, y, network z).
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sampler.x}}{(`sampler_net_attr`) Read-only. The sampler configuration object for the x attribute.}

\item{\code{sampler.y}}{(`sampler_net_attr`) Read-only. The sampler configuration object for the y attribute.}

\item{\code{sampler.z}}{(`sampler_net_attr`) Read-only. The sampler configuration object for the z network (overlap region).}

\item{\code{n_simulation}}{(`integer`) Read-only. The number of simulations to generate after burn-in.}

\item{\code{n_burn_in}}{(`integer`) Read-only. The number of burn-in iterations.}

\item{\code{init_empty}}{(`logical`) Read-only. Flag indicating whether simulations start from an empty state.}

\item{\code{cluster}}{(`cluster` object or `NULL`) Read-only. The parallel cluster object being used, or `NULL`.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-sampler_iglm-new}{\code{sampler_iglm_generator$new()}}
\item \href{#method-sampler_iglm-set_cluster}{\code{sampler_iglm_generator$set_cluster()}}
\item \href{#method-sampler_iglm-deactive_cluster}{\code{sampler_iglm_generator$deactive_cluster()}}
\item \href{#method-sampler_iglm-set_n_simulation}{\code{sampler_iglm_generator$set_n_simulation()}}
\item \href{#method-sampler_iglm-set_n_burn_in}{\code{sampler_iglm_generator$set_n_burn_in()}}
\item \href{#method-sampler_iglm-set_init_empty}{\code{sampler_iglm_generator$set_init_empty()}}
\item \href{#method-sampler_iglm-set_x_sampler}{\code{sampler_iglm_generator$set_x_sampler()}}
\item \href{#method-sampler_iglm-set_y_sampler}{\code{sampler_iglm_generator$set_y_sampler()}}
\item \href{#method-sampler_iglm-set_z_sampler}{\code{sampler_iglm_generator$set_z_sampler()}}
\item \href{#method-sampler_iglm-print}{\code{sampler_iglm_generator$print()}}
\item \href{#method-sampler_iglm-gather}{\code{sampler_iglm_generator$gather()}}
\item \href{#method-sampler_iglm-save}{\code{sampler_iglm_generator$save()}}
\item \href{#method-sampler_iglm-clone}{\code{sampler_iglm_generator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-new"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-new}{}}}
\subsection{Method \code{new()}}{
Create a new `sampler_iglm` object. Initializes all sampler settings,
using defaults for component samplers (`sampler.net_attr`) if not provided,
and validates inputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$new(
  sampler.x = NULL,
  sampler.y = NULL,
  sampler.z = NULL,
  n_simulation = 100,
  n_burn_in = 10,
  init_empty = TRUE,
  cluster = NULL,
  file = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sampler.x}}{An object of class `sampler_net_attr` controlling
sampling for the x attribute. If `NULL`, defaults from `sampler.net_attr()` are used.}

\item{\code{sampler.y}}{An object of class `sampler_net_attr` controlling
sampling for the y attribute. If `NULL`, defaults from `sampler.net_attr()` are used.}

\item{\code{sampler.z}}{An object of class `sampler_net_attr` controlling
sampling for the z network (within the defined neighborhood/overlap).
If `NULL`, defaults from `sampler.net_attr()` are used.}

\item{\code{n_simulation}}{(integer) The number of network/attribute configurations
to simulate and store after the burn-in period. Default is 100. Must be non-negative.}

\item{\code{n_burn_in}}{(integer) The number of initial MCMC iterations to discard
(burn-in) before starting to collect simulations. Default is 10. Must be non-negative.}

\item{\code{init_empty}}{(logical) If `TRUE` (default), the MCMC chain is
initialized from an empty state (e.g., empty network, attributes at mean).
If `FALSE`, initialization might depend on the specific sampler implementation
(e.g., starting from observed data).}

\item{\code{cluster}}{A parallel cluster object (e.g., from the `parallel` package)
to use for running simulations in parallel. If `NULL` (default), simulations
are run sequentially.}

\item{\code{file}}{(character or `NULL`) If provided, loads the sampler state from
the specified .rds file instead of initializing from parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `sampler_iglm` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_cluster"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_cluster}{}}}
\subsection{Method \code{set_cluster()}}{
Sets the parallel cluster object to be used for simulations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_cluster(cluster)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cluster}}{A parallel cluster object from the `parallel` package.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-deactive_cluster"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-deactive_cluster}{}}}
\subsection{Method \code{deactive_cluster()}}{
Deactivates parallel processing for this sampler instance by setting
the internal cluster object reference to `NULL`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$deactive_cluster()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The `sampler_iglm` object itself (`self`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_n_simulation"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_n_simulation}{}}}
\subsection{Method \code{set_n_simulation()}}{
Sets the number of simulations to generate after burn-in.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_n_simulation(n_simulation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_simulation}}{(integer) The number of simulations to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_n_burn_in"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_n_burn_in}{}}}
\subsection{Method \code{set_n_burn_in()}}{
Sets the number of burn-in iterations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_n_burn_in(n_burn_in)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_burn_in}}{(integer) The number of burn-in iterations to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_init_empty"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_init_empty}{}}}
\subsection{Method \code{set_init_empty()}}{
Sets whether to initialize simulations from an empty state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_init_empty(init_empty)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{init_empty}}{(logical) `TRUE` to initialize from empty, `FALSE` otherwise.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_x_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_x_sampler}{}}}
\subsection{Method \code{set_x_sampler()}}{
Sets the sampler configuration for the x attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_x_sampler(sampler.x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sampler.x}}{An object of class `sampler_net_attr`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_y_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_y_sampler}{}}}
\subsection{Method \code{set_y_sampler()}}{
Sets the sampler configuration for the y attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_y_sampler(sampler.y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sampler.y}}{An object of class `sampler_net_attr`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-set_z_sampler"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-set_z_sampler}{}}}
\subsection{Method \code{set_z_sampler()}}{
Sets the sampler configuration for the z attribute.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$set_z_sampler(sampler.z)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sampler.z}}{An object of class `sampler_net_attr`.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-print"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-print}{}}}
\subsection{Method \code{print()}}{
Prints a formatted summary of the sampler configuration to the console.
Includes core parameters (simulation count, burn-in, etc.) and calls
the `print` method for each component sampler (`sampler.x`, `sampler.y`, etc.).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$print(digits = 3, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{digits}}{(integer) Number of digits for formatting numeric values
(like `prob_nb`). Default: 3.}

\item{\code{...}}{Additional arguments (currently ignored).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The `sampler_iglm` object itself (`self`), invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-gather"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-gather}{}}}
\subsection{Method \code{gather()}}{
Gathers all data from private fields into a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$gather()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list containing all information of the sampler.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-save"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-save}{}}}
\subsection{Method \code{save()}}{
Save the object's complete state to a directory.
This will save the main sampler's settings to a file
named 'sampler_iglm_state.rds' within the specified
directory, and will also call the `save()` method for each
nested sampler (.x, .y, .z), saving them into the same
directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$save(file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{(character) The file to a directory where the
state files will be saved. The directory will be created
if it does not exist.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The object itself, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sampler_iglm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-sampler_iglm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{sampler_iglm_generator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
