% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{control.iglm}
\alias{control.iglm}
\title{Set Control Parameters for iglm Estimation}
\usage{
control.iglm(
  estimate_model = TRUE,
  fix_x = FALSE,
  display_progress = FALSE,
  return_samples = TRUE,
  offset_nonoverlap = 0,
  var = FALSE,
  non_stop = FALSE,
  tol = 0.001,
  max_it = 100,
  return_x = FALSE,
  return_y = FALSE,
  return_z = FALSE,
  accelerated = TRUE,
  cluster = NULL,
  exact = FALSE,
  updated_uncertainty = TRUE
)
}
\arguments{
\item{estimate_model}{(logical) If `TRUE` (default), the main model parameters
are estimated. If `FALSE`, estimation is skipped and only the preprocessing is done.}

\item{fix_x}{(logical) If `TRUE`, the 'x' predictor is held fixed
during estimation/simulation (fixed design in regression). Default is `FALSE`.}

\item{display_progress}{(logical) If `TRUE`, display progress messages or
a progress bar during estimation. Default is `FALSE`.}

\item{return_samples}{(logical). If \code{TRUE} (default), return simulated network/attribute
samples (i.e., \code{iglm.data} objects) generated during estimation (if applicable).}

\item{offset_nonoverlap}{(numeric) A value added to the linear predictor for
dyads not in the 'overlap' set. Default is `0`.}

\item{var}{(logical) If `TRUE`, attempt to calculate and return the
variance-covariance matrix of the estimated parameters. Default is `FALSE`.}

\item{non_stop}{(logical) If `TRUE`, the estimation algorithm continues until
`max_it` iterations, ignoring the `tol` convergence criterion. Default is `FALSE`.}

\item{tol}{(numeric) The tolerance level for convergence. The estimation stops
when the change in coefficients between iterations is less than `tol`.
Default is `0.001`.}

\item{max_it}{(integer) The maximum number of iterations for the estimation
algorithm. Default is `100`.}

\item{return_x}{(logical). If \code{TRUE}, return the change statistics for the \code{x} attribute Default is \code{FALSE}.
from samples. Default is `FALSE`. (Note: `return_samples=TRUE` likely implies this).}

\item{return_y}{(logical). If \code{TRUE}, return the change statistics for the \code{y} attribute Default is \code{FALSE}.}

\item{return_z}{(logical). If \code{TRUE}, return the change statistics for the \code{z} network. Default is \code{FALSE}.}

\item{accelerated}{(logical) If `TRUE` (default), an accelerated MM algorithm is used based on a Quasi Newton scheme described in the Supplemental Material of Fritz et al (2025).}

\item{cluster}{A parallel cluster object (e.g., from the `parallel` package)
to use for potentially parallelizing parts of the estimation or simulation.
Default is `NULL` (no parallelization).}

\item{exact}{(logical) If `TRUE`, potentially use an exact calculation method
of the pseudo Fisher information for assessing the uncertainty of the estimates. Default is `FALSE`.}

\item{updated_uncertainty}{(logical) If `TRUE` (default), potentially use an
updated method for calculating uncertainty estimates (based on the mean-value theorem as opposed to the Godambe Information).}
}
\value{
A list object of class `"control.iglm"` containing the specified
  control parameters.
}
\description{
Create a list of control parameters for the `iglm` estimation algorithm.
}
\references{
Fritz, C., Schweinberger, M. , Bhadra S., and D. R. Hunter (2025). A Regression Framework for Studying Relationships among Attributes under Network Interference. Journal of the American Statistical Association, to appear.
}
