% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_model.R
\name{summarise_model}
\alias{summarise_model}
\title{Summarise a Model Simulation}
\usage{
summarise_model(sim)
}
\arguments{
\item{sim}{A tibble of model output as produced by
\code{\link[idmodelr]{solve_ode}}.}
}
\value{
A tibble of summary information for a model simulation.
}
\description{
Provides simple summary statistics for a model produced using
\code{\link[idmodelr]{solve_ode}}. These include the final population
sizes, the time and size of the maximum epidemic peak, and the duration of
the epidemic.
}
\examples{

## Intialise
N = 100000
I_0 = 1
S_0 = N - I_0
R_0 = 1.1
beta = R_0

##Time for model to run over
tbegin = 0
tend = 50
times <- seq(tbegin, tend, 1)

##Vectorise input
parameters <- as.matrix(c(beta = beta))
inits <- as.matrix(c(S = S_0, I = I_0))

sim <- solve_ode(model = SI_ode, inits, parameters, times, as.data.frame = TRUE)

summarise_model(sim)
}
