% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_data.R
\name{summary.IDEMDATA}
\alias{summary.IDEMDATA}
\title{Summary of IDEMDATA object}
\usage{
\method{summary}{IDEMDATA}(object, opt = c("misstable", "missid", "trt"),
  endponly = FALSE, ...)
}
\arguments{
\item{object}{A class \code{IDEMDATA} object returned by \code{\link{imData}}}

\item{opt}{Types of the summarization
\itemize{

\item{\code{misstable}: }{Summarize the frequencies of each missing pattern}

\item{\code{missid}: }{Summarize the indices of subjects that need
    imputation, i.e. survivors with functional endpoint missing}

\item{\code{trt}: }{Treatment arms}
}}

\item{endponly}{Logical variable that indicates whether clinical outcomes not
used in calculating the functional outcome are considered as missing and
should be imputed. The default is \code{FALSE}, indicating that all
missing clinical outcomes will be imputed sequentially}

\item{...}{Extra arguments}
}
\value{
A dataframe with frequencies of each missing pattern when opt is \code{misstable}.

A vector of indices of subjects that need imputation when opt is \code{missid}.

A vector of treatment arms in the data when opt is \code{trt}.
}
\description{
Summarize the missing data information for class \code{IDEMDATA} objects
generated by \code{\link{imData}}.
}
\seealso{
\code{\link{imData}}
}
