% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R
\docType{methods}
\name{id_plot,idealstan-method}
\alias{id_plot,idealstan-method}
\title{Plot Results of \code{\link{id_estimate}}}
\usage{
\S4method{id_plot}{idealstan}(object, plot_type = "persons", ...)
}
\arguments{
\item{object}{A fitted \code{idealstan} object}

\item{plot_type}{Specify the plot as a character string. Currently 'persons' for legislator/person ideal point plot and 
'histogram' for a histogram of model estimates for given parameters.}

\item{...}{Additional arguments passed on to the underlying functions. See individual function documentation for details.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
This function allows you to access the full range of plotting options for fitted \code{idealstan} models.
}
\details{
\code{id_plot} is a wrapper function that can access the various plotting functions available in the \code{idealstan} package. 
   Currently, the options are limited to a plot of legislator/person ideal points with bills/item midpoints as an optional overlay.
   Additional plots will be available in future versions of \code{idealstan}.
}
\seealso{
\code{\link{id_plot_legis}} for a legislator/person ideal point plot, 
\code{\link{id_plot_all_hist}} for a standard histogram plot,
\code{\link{id_plot_compare}} for an ideal point plot of two different models of the same data,
\code{\link{id_plot_rhats}} for a histogram of \code{Rhat} values,
\code{\link{id_plot_sims}} for plotting true versus estimated values,
\code{\link{id_estimate}} for how to estimate an \code{idealstan} object.
}
