% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/valid.R
\name{icd9IsReal}
\alias{icd9GetReal}
\alias{icd9GetRealDecimal}
\alias{icd9GetRealShort}
\alias{icd9IsReal}
\alias{icd9IsRealDecimal}
\alias{icd9IsRealShort}
\title{Check whether ICD-9 codes exist}
\usage{
icd9IsReal(icd9, isShort = icd9GuessIsShort(icd9), majorOk = TRUE)

icd9IsRealShort(icd9Short, majorOk = TRUE)

icd9IsRealDecimal(icd9Decimal, majorOk = TRUE)

icd9GetReal(icd9, isShort = icd9GuessIsShort(icd9), majorOk = TRUE)

icd9GetRealShort(icd9Short, majorOk = TRUE)

icd9GetRealDecimal(icd9Decimal, majorOk = TRUE)
}
\arguments{
\item{icd9}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{isShort}{single logical value which determines whether the ICD-9 code
provided is in short (TRUE) or decimal (FALSE) form. Where reasonable, this
is guessed from the input data.}

\item{majorOk}{single logical, if \code{TRUE} will consider a three-digit
code to be real, even though the majority of three-digit codes aren't
billable (which is at present synonmous with 'realness').}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}
}
\value{
logical vector
}
\description{
This is different from syntactic validity: it looks it up in the
  canonical list of ICD-9 codes published by the CMS, and which are included
  in this package under \code{extdata}. Checking syntactic validity using
  \code{link{icd9IsValid}} etc. is still useful, with a changing list of
  icd-9 codes over time, and possible imperfections in the master lists
  derived from CMS.
}
\section{Functions}{
\itemize{
\item \code{icd9IsRealShort}: 

\item \code{icd9IsRealDecimal}: 

\item \code{icd9GetReal}: 

\item \code{icd9GetRealShort}: 

\item \code{icd9GetRealDecimal}: 
}}

