% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9CondenseToMajor}
\alias{icd9CondenseToMajor}
\title{condense list of short ICD-9 code into minimal set of major-part-only
  codes}
\usage{
icd9CondenseToMajor(icd9Short, onlyReal, dropNonReal = TRUE,
  invalidAction = c("stop", "ignore", "silent", "warn"))
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{onlyReal}{single logical value, if TRUE, will limit the search to those
codes which appear in the master list, not just syntactically valid codes.
Since nearly valid, out-dated or new codes may be missed, not limiting to
'real' values will be useful. Ultimately, there will need to be annual (and
all-time) master lists of codes and the ability to test against a given
master list given the year of the ICD-9 coding.}

\item{dropNonReal}{single logical, if TRUE, and \code{onlyReal} is TRUE, then
codes not found in the master list are dropped; otherwise they are included
in the output.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\description{
This can be thought of as the inverse operation to
  icd9Children("123"). The list given must already contain the parents,
  because this function will never add a parent ICD-9 which, although may
  have all children present, may itself have an additional clinical meaning.
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9mj\%}},
  \code{\link{icd9ExpandRangeMajor}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9ChildrenDecimal}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseToExplain}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}

