% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R
\name{is_billable}
\alias{is_billable}
\alias{is_billable.icd9}
\alias{is_billable.icd9cm}
\alias{is_billable.icd10}
\alias{is_billable.icd10cm}
\alias{is_billable.default}
\title{Check whether a code is billable according to ICD-9-CM or ICD-10-CM}
\usage{
is_billable(x, short_code = guess_short(x), ...)

\method{is_billable}{icd9}(x, short_code = guess_short(x), ...)

\method{is_billable}{icd9cm}(x, short_code = guess_short(x), ...)

\method{is_billable}{icd10}(x, short_code = guess_short(x), ...)

\method{is_billable}{icd10cm}(x, short_code = guess_short(x), ...)

\method{is_billable}{default}(x, short_code = guess_short(x), ...)
}
\arguments{
\item{x}{input vector to test}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}
}
\description{
Using the equivalent \code{\link[=is_leaf]{is_leaf()}} is preferred.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd9cm}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd10}: Prefer 'leaf' to 'billable' for generality.

\item \code{icd10cm}: Prefer 'leaf' to 'billable' for generality.

\item \code{default}: Prefer 'leaf' to 'billable' for generality.
}}

\seealso{
\code{\link[=get_leaf]{get_leaf()}}
}
