% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{icd_count_comorbid}
\alias{icd_count_comorbid}
\title{Count number of comorbidities per patient}
\usage{
icd_count_comorbid(x, visit_name = get_visit_name(x), return_df = FALSE)
}
\arguments{
\item{x}{data frame with one row per patient, and a true/false or 1/0 flag
for each column. By default, the first column is the patient identifier and
is not counted. If \code{visit_name} is not specified, the first column is
used.}

\item{visit_name}{The name of the column in the data frame which contains the
patient or visit identifier. Typically this is the visit identifier, since
patients come leave and enter hospital with different ICD-9 codes. It is a
character vector of length one. If left empty, or \code{NULL}, then an
attempt is made to guess which field has the ID for the patient encounter
(not a patient ID, although this can of course be specified directly). The
guesses proceed until a single match is made. Data frames may be wide with
many matching fields, so to avoid false positives, anything but a single
match is rejected. If there are no successful guesses, and \code{visit_id}
was not specified, then the first column of the data frame is used.}

\item{return_df}{single logical value, if \code{TRUE}, return the result as a data frame with the first column being
the \code{visit_id}, and the second being the count. If \code{visit_id} was a factor or named differently in the
input, this is preserved.}
}
\description{
\code{icd_count_comorbid} differs from the other counting functions in that
it counts \emph{comorbidities}, not individual diagnoses. It accepts any
\code{data.frame} with either logical or binary contents, with a single
column for visit_name. No checks are made to see whether visit_name is
duplicated.
}
