% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{icd9_order_short}
\alias{icd9_order_short}
\title{Get order of short-form ICD-9 codes}
\usage{
icd9_order_short(x)
}
\arguments{
\item{x}{vector or factor of ICD-9 codes}
}
\value{
vector of integers with length of the non-NA values in \code{x}
}
\description{
Puts E codes after V codes. \code{NA} values can't be ordered and are dropped
with a warning if found.
}
\examples{
x <- icd:::generate_random_decimal_icd9(1e4)
system.time(icd:::icd9_sort_cpp(x)) # vastly quicker
system.time(icd:::icd9_order_short(x))
if (require("microbenchmark", quietly = TRUE)) {
  # fastmatch was fractionally faster, but either is very slow
  microbenchmark(icd:::icd9_order_short(x),
                 icd:::icd9_order_short_r(x),
                 times = 10)
  # C++ method (which also ignores NA values) is 100x faster.
}
}
\keyword{internal}
