% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{strip}
\alias{strip}
\title{Strip character(s) from character vector}
\usage{
strip(x, pattern = " ", use_bytes = TRUE)
}
\arguments{
\item{x}{character vector}

\item{pattern}{passed to \code{gsub} default is " "}

\item{use_bytes}{single logical passed to \code{base::gsub}, default is the
slightly quicker \code{TRUE}}
}
\value{
character vector of same length as input
}
\description{
\code{gsub} is probably quicker than \code{stringr}/\code{stringi}. For
comorbidity processing, this package prefers the faster \link{base}
functions, whereas \code{stringr} is used for tasks which are not time
critical, e.g. parsing source data to be included in the distributed
\code{icd} package.
}
\examples{
\dontrun{
x <- random_string(25000);
microbenchmark::microbenchmark(
  gsub(x = x, pattern = "A", replacement = "", fixed = TRUE, useBytes = TRUE),
  gsub(x = x, pattern = "A", replacement = "", fixed = TRUE, useBytes = TRUE, perl = TRUE),
  gsub(x = x, pattern = "A", replacement = ""),
  stringr::str_replace_all(x, "A", "")
  )
}
}
\keyword{internal}

